/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: Hil_Compiler.h 159 2018-10-18 12:32:41Z AndreasB $:

  Description:
    Definitions of Compiler Settings

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2016-11-30  File created.

**************************************************************************************/
#ifndef HIL_COMPILER_H_
#define HIL_COMPILER_H_


/*****************************************************************************/
/* Set byte alignment for structure members. */

#if (defined (__GNUC__) || defined (__clang__)) && !defined(USER_COMPILER)
/* support for GNU and clang compiler. Note the clang compiler may also set
 * _MSC_VER, so __clang__ must be checked before _MSC_VER. */

  #define __HIL_VARIABLE_LENGTH_ARRAY
  #define __HIL_PACKED_PRE
  #define __HIL_PACKED_POST    __attribute__((__packed__))

  /* macro for setting DWORD alignment of a tag's beginning */
  #define __HIL_ALIGNED_DWORD__   __attribute__ ((aligned (4)))

#elif defined (_MSC_VER) && !defined(USER_COMPILER)
/* support for MS Visual C++ compiler */

  #if _MSC_VER >= 1000
    #define __HIL_VARIABLE_LENGTH_ARRAY   1
    #define __HIL_PACKED_PRE
    #define __HIL_PACKED_POST
    #define __HIL_PRAGMA_PACK_ENABLE
    #define __HIL_PRAGMA_PACK_1(label) pack(push, label, 1)
    #define __HIL_PRAGMA_UNPACK_1(label) pack(pop, label)
    #ifndef STRICT
      #define STRICT
    #endif
  #endif
#elif (defined (__ADS__) || defined (__REALVIEW__)) && !defined(USER_COMPILER)
/* support for REALVIEW ARM compiler */

  #define __HIL_VARIABLE_LENGTH_ARRAY          /* setting is not verified */
  #define __HIL_PACKED_PRE   __packed
  #define __HIL_PACKED_POST

#else

  #include "User_Compiler.h"

#endif

/*****************************************************************************/

#endif /* HIL_COMPILER_H_ */
